(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     75253,       1741]
NotebookOptionsPosition[     73927,       1712]
NotebookOutlinePosition[     74332,       1728]
CellTagsIndexPosition[     74289,       1725]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"radii", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"{", 
     RowBox[{
     "233.74", ",", "163.23", ",", "137.53", ",", "174.14", ",", "197.61", 
      ",", "128.77", ",", "156.71", ",", "162.50", ",", "132.05", ",", 
      "141.52", ",", "157.67", ",", "121.92", ",", "132.05", ",", "132.20", 
      ",", "201.92", ",", "122.81", ",", "152.46", ",", "163.33", ",", 
      "127.73", ",", "148.53", ",", "225.02", ",", "167.70", ",", "170.44", 
      ",", "198.88", ",", "171.29", ",", "157.58", ",", "150.42", ",", 
      "158.15", ",", "143.81", ",", "177.44", ",", "195.28", ",", "93.78", 
      ",", "165.65", ",", "104.89", ",", "169.07", ",", "158.82", ",", 
      "165.44", ",", "190.65", ",", "183.00", ",", "191.53", ",", "178.76", 
      ",", "203.37", ",", "175.05", ",", "151.18", ",", "186.28", ",", 
      "172.55", ",", "177.32", ",", "160.89", ",", "182.92", ",", "155.99", 
      ",", "148.12", ",", "172.37", ",", "139.03", ",", "139.33", ",", 
      "140.90", ",", "160.31", ",", "235.84", ",", "174.41", ",", "178.44", 
      ",", "182.70", ",", "172.37", ",", "144.93", ",", "148.63", ",", 
      "140.02", ",", "159.84", ",", "205.25", ",", "151.61", ",", "147.21", 
      ",", "152.73", ",", "130.04", ",", "195.18", ",", "114.06", ",", 
      "220.00", ",", "172.17", ",", "175.76", ",", "167.00", ",", "196.02", 
      ",", "202.18", ",", "156.78", ",", "164.56", ",", "184.95", ",", 
      "153.38", ",", "211.75", ",", "146.55", ",", "182.98", ",", "161.61", 
      ",", "213.20", ",", "160.04", ",", "169.19", ",", "117.72", ",", 
      "119.71", ",", "137.40", ",", "185.41", ",", "156.46", ",", "150.23", 
      ",", "199.69", ",", "230.27", ",", "194.19", ",", "170.82", ",", 
      "163.50", ",", "160.18", ",", "163.30", ",", "148.79", ",", "142.20", 
      ",", "84.06", ",", "115.14", ",", "172.30", ",", "229.77", ",", 
      "152.18", ",", "147.99", ",", "179.09", ",", "220.58", ",", "189.52", 
      ",", "139.83", ",", "150.92", ",", "189.78", ",", "155.33", ",", 
      "170.13", ",", "164.67", ",", "153.02", ",", "185.24", ",", "173.45", 
      ",", "169.49", ",", "139.76", ",", "198.89", ",", "142.25", ",", 
      "110.19", ",", "160.03", ",", "212.29", ",", "146.10", ",", "148.62", 
      ",", "186.19", ",", "192.75", ",", "201.30", ",", "136.38", ",", 
      "172.08", ",", "173.81", ",", "207.10", ",", "226.63", ",", "118.33", 
      ",", "137.97", ",", "143.51", ",", "176.76", ",", "134.38", ",", 
      "175.23", ",", "156.16", ",", "142.84", ",", "196.98", ",", "250.42", 
      ",", "200.06", ",", "219.05", ",", "209.26", ",", "166.60", ",", 
      "148.03", ",", "146.21", ",", "214.69", ",", "173.42", ",", "124.64", 
      ",", "112.38", ",", "131.33", ",", "158.49", ",", "188.72", ",", 
      "173.36", ",", "114.49", ",", "198.43", ",", "190.48", ",", "171.56", 
      ",", "187.33", ",", "152.27", ",", "167.44", ",", "183.53", ",", 
      "148.25", ",", "215.04", ",", "164.33", ",", "183.01", ",", "142.57", 
      ",", "110.33", ",", "181.69", ",", "186.59", ",", "158.53", ",", 
      "218.58", ",", "170.77", ",", "202.31", ",", "148.88", ",", "144.24", 
      ",", "185.53", ",", "171.52", ",", "189.31", ",", "211.26", ",", 
      "191.22", ",", "161.99", ",", "206.49", ",", "159.29", ",", "123.97", 
      ",", "194.79", ",", "139.65", ",", "105.01", ",", "159.79", ",", 
      "127.39"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", "radii", "]"}], "\[IndentingNewLine]", 
 RowBox[{"StandardDeviation", "[", "radii", "]"}]}], "Input",
 CellChangeTimes->{{3.902540485409638*^9, 3.9025405270812283`*^9}, {
  3.902541094300934*^9, 3.902541105916259*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"30d5095c-ea0b-4d36-bb56-98f8fc9caa0d"],

Cell[BoxData["83.28246231155778`"], "Output",
 CellChangeTimes->{{3.902540517530094*^9, 3.902540527424261*^9}, {
  3.902541108336996*^9, 3.902541129969672*^9}},
 CellLabel->"Out[2]=",ExpressionUUID->"48635599-8d07-4d98-b25d-a8adb232aa80"],

Cell[BoxData["14.92940322903389`"], "Output",
 CellChangeTimes->{{3.902540517530094*^9, 3.902540527424261*^9}, {
  3.902541108336996*^9, 3.9025411299736853`*^9}},
 CellLabel->"Out[3]=",ExpressionUUID->"d447e43a-038c-40e8-a842-74b715e80ae2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"thicknesses", "=", 
   RowBox[{"{", 
    RowBox[{
    "6.7", ",", "7.6", ",", "6.7", ",", "7.3", ",", "6.1", ",", "6.1", ",", 
     "6.3", ",", "5.9", ",", "7.4", ",", "4.7", ",", "5.4", ",", "7.2", ",", 
     "7.1", ",", "6.4", ",", "6.8", ",", "6.4", ",", "6.2", ",", "7.1", ",", 
     "6.0", ",", "7.7", ",", "8.7", ",", "8.2", ",", "6.9", ",", "5.8", ",", 
     "6.0", ",", "7.1", ",", "5.1", ",", "6.1", ",", "5.6", ",", "6.2", ",", 
     "7.2", ",", "5.5", ",", "5.5", ",", "7.0", ",", "4.6", ",", "5.7", ",", 
     "5.8", ",", "6.6", ",", "6.6", ",", "5.7", ",", "6.9", ",", "5.8", ",", 
     "5.1", ",", "4.5", ",", "7.1", ",", "7.9", ",", "7.4", ",", "5.8", ",", 
     "7.4", ",", "6.3", ",", "5.5", ",", "7.2", ",", "6.2", ",", "9.3", ",", 
     "6.5", ",", "8.7", ",", "5.3", ",", "5.7", ",", "6.3", ",", "7.5", ",", 
     "6.2", ",", "6.7", ",", "7.0", ",", "5.6", ",", "6.5", ",", "5.5", ",", 
     "6.5", ",", "7.9", ",", "6.5", ",", "5.8", ",", "6.2", ",", "8.3", ",", 
     "5.9", ",", "8.1", ",", "7.4", ",", "11.4", ",", "6.8", ",", "5.0", ",", 
     "7.0", ",", "7.1", ",", "6.9", ",", "5.8"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9025406330955133`*^9, 3.902540640120008*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"bc70ea71-f64b-4611-a5af-5eb80b35f6bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "histogrammen", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Histogram", "[", "radii", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Histogram", "[", "thicknesses", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9025404906522293`*^9, 3.902540493595652*^9}, {
  3.902540643136503*^9, 3.902540679577054*^9}, {3.902540775372699*^9, 
  3.902540901254891*^9}, {3.902541023730256*^9, 3.902541048339319*^9}, {
  3.902541094304183*^9, 3.902541094311225*^9}, {3.902541138293799*^9, 
  3.9025412047043047`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"5b80e225-eef8-4f55-b284-2adea0616afb"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.623], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.623], Thickness[Small]}], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{40., 0}, {50., 2.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{20.50959314471531, 57.87929729222928}, {
           87.93690173219912, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 2]& ,
        TagBoxNote->"2"],
       StyleBox["2", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[2, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{50., 0}, {60., 11.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{57.37929729222928, 94.74900143974325}, {
           53.55139702709517, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 11]& ,
        TagBoxNote->"11"],
       StyleBox["11", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[11, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{60., 0}, {70., 22.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{94.24900143974325, 131.61870558725724`}, {
           11.52466905419034, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 22]& ,
        TagBoxNote->"22"],
       StyleBox["22", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[22, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{70., 0}, {80., 50.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{131.11870558725724`, 
           168.4884097347712}, {-95.45245669502197, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 50]& ,
        TagBoxNote->"50"],
       StyleBox["50", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[50, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{80., 0}, {90., 52.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{167.9884097347712, 
           205.35811388228518`}, {-103.09367996282285`, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 52]& ,
        TagBoxNote->"52"],
       StyleBox["52", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[52, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{90., 0}, {100., 35.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{204.85811388228518`, 
           242.22781802979915`}, {-38.143282186515364`, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 35]& ,
        TagBoxNote->"35"],
       StyleBox["35", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[35, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{100., 0}, {110., 18.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{241.72781802979915`, 279.0975221773131}, {
           26.80711558979209, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 18]& ,
        TagBoxNote->"18"],
       StyleBox["18", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[18, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{110., 0}, {120., 8.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{278.5975221773131, 315.9672263248271}, {
           65.01323192879649, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 8]& ,
        TagBoxNote->"8"],
       StyleBox["8", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[8, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{120., 0}, {130., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{315.4672263248271, 352.83693047234107`}, {
           91.75751336609956, 96.078125}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], 
       "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{38.2, 0},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{40., 130.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9025404941524477`*^9, {3.902540648552994*^9, 3.902540680665782*^9}, {
   3.902540801234727*^9, 3.9025409015004177`*^9}, {3.90254103644416*^9, 
   3.902541048676257*^9}, {3.902541108404746*^9, 3.902541206262527*^9}},
 CellLabel->"Out[35]=",ExpressionUUID->"844ad433-ce0c-41db-8025-e34bef9422d6"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.63], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.63], Thickness[Small]}], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{4., 0}, {5., 3.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{20.50959314471538, 62.488010310668614`}, {
           75.02586931419074, 96.07812500000001}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 3]& ,
        TagBoxNote->"3"],
       StyleBox["3", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[3, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{5., 0}, {6., 22.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{61.988010310668614`, 
           103.96642747662185`}, {-55.138416695934566`, 96.07812500000001}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 22]& ,
        TagBoxNote->"22"],
       StyleBox["22", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[22, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{6., 0}, {7., 29.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{103.46642747662185`, 
           145.44484464257505`}, {-103.09367996282286`, 96.07812500000001}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 29]& ,
        TagBoxNote->"29"],
       StyleBox["29", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[29, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{7., 0}, {8., 21.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{144.94484464257505`, 
           186.9232618085283}, {-48.287664800664814`, 96.07812500000001}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 21]& ,
        TagBoxNote->"21"],
       StyleBox["21", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[21, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{8., 0}, {9., 5.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{186.4232618085283, 228.40167897448157`}, {
           61.324365523651245`, 96.07812500000001}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 5]& ,
        TagBoxNote->"5"],
       StyleBox["5", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[5, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{9., 0}, {10., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{227.90167897448157`, 269.8800961404348}, {
           88.72737310473026, 96.07812500000001}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{11., 0}, {12., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{310.858513306388, 352.83693047234124`}, {
           88.72737310473026, 96.07812500000001}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{3.84, 0},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{4., 12.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9025404941524477`*^9, {3.902540648552994*^9, 3.902540680665782*^9}, {
   3.902540801234727*^9, 3.9025409015004177`*^9}, {3.90254103644416*^9, 
   3.902541048676257*^9}, {3.902541108404746*^9, 3.902541206288216*^9}},
 CellLabel->"Out[36]=",ExpressionUUID->"37c20daf-489e-4ef0-9ca0-e568583d89c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"smooth", " ", "histograms"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"distradii", "=", 
     RowBox[{"SmoothKernelDistribution", "[", "radii", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"distthicknesses", "=", 
     RowBox[{"SmoothKernelDistribution", "[", "thicknesses", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"LogLinearPlot", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{"distradii", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"10", "^", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"LogLinearPlot", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{"distthicknesses", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"10", "^", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9025412100967493`*^9, 3.902541230695438*^9}, {
  3.90254145889528*^9, 3.902541468023766*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"91a52063-d78f-47dd-9205-1de0448c3a60"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQA2IQvdBeZ87GbKYDDFBQctUvuiwFwffILpSyjkXwP0zb
NuOIH4Lv8M5h6nVDBP/enNC+v98Z4XyZX3UNni0I/rQtF1MezmGA822Y69rc
/P7uh/GXKDOIeC39Cef/azrzdB3fNzi/bpLGY3OtT3D+moCIpEaBt3D+ijt1
obcNnsL5gmeLF71/fQvOT/nCv9Of4SScv+6Axs1KiZX2MP5fARMB9z0X4Xw+
dt5Xf1gfwPmBSx986T35HM5/YpYaJ8/xHs4XM0m1MCn8DOef6PWt/e79Hc5X
TOz7aPXkF5wf2mJvFXXqH5w/c4LKzT9mjA4w/pe2xPpd+sxw/rXYymZ3eVY4
v6fQdv6Ut2xwflVSaHfmVwQ/Mzi33O4vgu9mOtf/BQ87nM/w889/ax0Ev7Rh
T8LjLAQ/pfCKz44iBD8o6Y1FbxWCb+AiI2jeheCH3phtvm0xgg8Aav2Qxg==

       "]], LineBox[CompressedData["
1:eJwVV3k4lt3XRW95Zs/93OX1I0JIRAipdM5WhkIpZZ6FihQqJIRMGTJmeAwN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       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCwB2Iw/bKrYAODiAMDFCyx9U6IYEfwi0M4V/zlQvCFmlrN
PYQQ/EcznOvfiiL4G9czHp8kieAH3K0Nu6uA4PdZlJUW6SP4cf4me8WNEXzd
tE8se80Q/DOT86aw2yH4XO/TNs/xQfDbl4Z/PJaJ4IftEbXMyUXw1S5fbhAs
RPCPMQQIxFQg+CwxHvof2xD8BiHLXOklCH5lvdTL/HtI9vtMOc/0CMGfJcG3
bepTBH/PRsbm3W8Q/H+PX8iw/0bwmz22B8wTF4XzewVDdpwJQPAXLu5t1zyM
4O+/LSMdtVsMznc3atr1apE4wj9zmP0/zZWA89erRr+P7JCE82/LLbDTzJNC
uEebsTk/XRrO7w63uCwaIAPn803vljD2kYXzr7qd4dnhLAfns4k+5pmrJQ/n
T/vN1VgjpADn36vub4xqR/A9tnRFvvmJ4K/9JrzGskwR4R+PDhbzVwh+SrHr
e5s3CH7TPKZbTu8Q/H1fatb7fULwzRYWRqX9QvBVfkVtmMqlBOczrNGN+aKF
4Mtdf+X2SwfBt2FaYcigj+CXRyix8xgj+O9YxDcpWyP4d2IZOIK9EfxfHXs/
Rfgi+BJbqu7G+SP4wVxfN2UFI/intr2MbYpG8F88XObREYvgs/GmGPfFI/hO
yfc4ZiUj+Al9sz/PT0Xw63ZG3FuajuDPeSJ6cnUmgr+T//LmjdkIPgAlg8aM

       "]]},
     Annotation[#, "Charting`Private`Tag$9707#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-2.3025848580363832`, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{Automatic, Automatic}, {Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{
     Automatic, Automatic}, {{{-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
    Automatic}]], "Output",
 CellChangeTimes->{{3.902541208397676*^9, 3.9025412212458143`*^9}, {
  3.902541464762369*^9, 3.902541468581115*^9}},
 CellLabel->"Out[55]=",ExpressionUUID->"57be7b0f-3844-417d-b104-c234693c2cbd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQvdBeZ87GbKYDDFBQctUvuiwFwffILpSyjkXwP0zb
NuOIH4Lv8M5h6nVDBP/enNC+v98Z4XyZX3UNni0I/rQtF1MezmGA822Y69rc
/P7uh/GXKDOIeC39Cef/azrzdB3fNzi/bpLGY3OtT3D+moCIpEaBt3D+ijt1
obcNnsL5gmeLF71/fQvOT/nCv9Of4SScv+6Axs1KiZX2MP5fARMB9z0X4Xw+
dt5Xf1gfwPmBSx986T35HM5/YpYaJ8/xHs5feXpdU4c6gp+X8GPZRzcE/0dn
9/vDrQi+2EOtYKOJCD4A+Nlpqg==
       "]], LineBox[CompressedData["
1:eJwVl2k41H8XxsfMVCr+ZCklCS1EpYUK/e5vKhXZlxSylyjJLlpICBUllRAS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       "]], LineBox[CompressedData["
1:eJxFz21MkmEYBeA3ImKMTFCCQFAsaJrOiqW5yDU0YDM0YyYfYQ01yjaYs9U0
o8AtWZZuDXQrFS20VjIDmYWt2szaorZWjlpaDDE3YKRl6iZufW3tuc92dnb9
PFyt4XANDsMw0d/+W1mvBGM68fux//HzrfeCbvCOy45Azyj46qyHqhkDh4te
iFk+cKHD3/jpHTiuXQ6VT4OPjBHoyRGwi0svfv8dfDKYN1yCrUP+oGlolqSC
efrww0t88BljRcybDabad5dnCcGy4A8+RQke19b6Jq+DXTo1RU8gwL+6fXbr
N3COM7//bYiIPMALjflGSMgOY02BzURGbv+d5pDVJyDfqRxPnOEmIl8osxZ1
sCnInZ6yba5kKjIrd5aWtQq2vbausJeSkBsuMiOGQDJy3+1rLRnPacjPplJY
qsebkCW7zKPRW3Tkl11rSxe6GchDPPW80rIZeYrTW5ChZyL/2r6m2aBjIbdW
7JmgHUpBTuhsZQgOspH94jfkR4UcZAJthtydmYrcsUoyNVHTkAPn202qFrDU
c0UZWwE7l5MG889y4Y/Ugs+LgqvrD8wLY2BzD25SNAd+utg0VLIAzu2rU52I
g7fGVQ9spHRkbDD76GImmPMxKo5ngYW4uzuxHPA5Rfp6sgA8h6e7t+wFf9Zg
RHkxOG55sqCQgRmexi+VpWA5acldKwf7RiIasxocnh6QWjRgwoZqQdsxsKgq
QLxRBT7edvOnvQZs9CoC/Tpw11faq/unwN6NE8Ou0+A/q9/X2Q==
       "]]},
     Annotation[#, "Charting`Private`Tag$10271#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-2.3025848580363832`, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{Automatic, Automatic}, {Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{
     Automatic, Automatic}, {{{-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.006367567650246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.294049640102028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.699514748210191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.85366542803745, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       8.987196820661973, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.104979856318357, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.903487552536127, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.308952660644293`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.596634733096073`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       10.819778284410283`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.002099841204238`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.156250521031495`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.289781913656018`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.407564949312402`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
    Automatic}]], "Output",
 CellChangeTimes->{{3.902541208397676*^9, 3.9025412212458143`*^9}, {
  3.902541464762369*^9, 3.902541468700672*^9}},
 CellLabel->"Out[56]=",ExpressionUUID->"42d726b6-1650-497f-81d4-80fcc57ccd9b"]
}, Open  ]]
},
WindowSize->{960, 472},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
FrontEndVersion->"13.2 for Microsoft Windows (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"9b9029fb-f69f-4138-89c6-797f6e0f708b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3759, 55, 352, "Input",ExpressionUUID->"30d5095c-ea0b-4d36-bb56-98f8fc9caa0d"],
Cell[4342, 79, 238, 3, 32, "Output",ExpressionUUID->"48635599-8d07-4d98-b25d-a8adb232aa80"],
Cell[4583, 84, 240, 3, 32, "Output",ExpressionUUID->"d447e43a-038c-40e8-a842-74b715e80ae2"]
}, Open  ]],
Cell[4838, 90, 1320, 20, 86, "Input",ExpressionUUID->"bc70ea71-f64b-4611-a5af-5eb80b35f6bc"],
Cell[CellGroupData[{
Cell[6183, 114, 623, 11, 67, "Input",ExpressionUUID->"5b80e225-eef8-4f55-b284-2adea0616afb"],
Cell[6809, 127, 7303, 216, 241, "Output",ExpressionUUID->"844ad433-ce0c-41db-8025-e34bef9422d6"],
Cell[14115, 345, 5961, 173, 242, "Output",ExpressionUUID->"37c20daf-489e-4ef0-9ca0-e568583d89c7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20113, 523, 1428, 37, 105, "Input",ExpressionUUID->"91a52063-d78f-47dd-9205-1de0448c3a60"],
Cell[21544, 562, 26522, 579, 241, "Output",ExpressionUUID->"57be7b0f-3844-417d-b104-c234693c2cbd"],
Cell[48069, 1143, 25842, 566, 248, "Output",ExpressionUUID->"42d726b6-1650-497f-81d4-80fcc57ccd9b"]
}, Open  ]]
}
]
*)

